//+------------------------------------------------------------------+
//|                                          Similar Differences.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property script_show_inputs

input uchar Difference=5;

struct func {double c[];};
func arr[];
int price[],diff,period;
double data[],curdata[];
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   diff=MathMax(1,Difference);
   ArrayResize(arr,diff);
   ArrayResize(data,diff);
   ArrayResize(curdata,diff);

   int s=2;
   double a[];
   ArrayResize(a,s);
   a[0]=1;
   a[1]=-1;
   for(int i=0;i<diff;i++)
     {
      ArrayResize(arr[i].c,s);
      ArrayCopy(arr[i].c,a);
      FiniteDifference(a,s);
     }

   period=diff+1;
   ArrayResize(price,period);
   for(int i=period-1;i>=0;i--)
      ShiftPrice(iOpen(_Symbol,PERIOD_CURRENT,i));
   CalcData(data);

   int index=0,bars=MathMin(iBars(_Symbol,PERIOD_CURRENT),TerminalInfoInteger(TERMINAL_MAXBARS));
   double difference=DBL_MAX;

   for(int i=bars-1;i>bars-period-1;i--)
      ShiftPrice(iOpen(_Symbol,PERIOD_CURRENT,i));

   for(int i=bars-period-1;i>0;i--)
     {
      ShiftPrice(iOpen(_Symbol,PERIOD_CURRENT,i));
      CalcData(curdata);
      double current=0;
      for(int i=0;i<diff;i++)
        {
         double d=1-curdata[i]/data[i];
         current=current+d*d;
        }

      if(difference>current)
        {
         difference=current;
         index=i;
        }
     }

   int w=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0),
       h=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);

   ChartSetInteger(0,CHART_AUTOSCROLL,false);
   ChartNavigate(0,CHART_END,-index);
   ArrowCreate(index);
   ChartScreenShot(0,IntegerToString(diff)+"_"+IntegerToString(index)+".png",w,h,ALIGN_LEFT);

   ChartSetInteger(0,CHART_AUTOSCROLL,true);
   ArrowCreate(0);
   ChartScreenShot(0,IntegerToString(diff)+"_0.png",w,h,ALIGN_LEFT);

   ObjectsDeleteAll(0,"arrow");

   for(int i=period-1;i>=0;i--)
      ShiftPrice(iOpen(_Symbol,PERIOD_CURRENT,index+i));
   CalcData(curdata);

   for(int i=0;i<diff;i++)
      data[i]=data[i]-curdata[i];

   Print("Similar bar index ",index);
   ArrayPrint(data);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ArrowCreate(int bar)
  {
//---
   for(int i=0;i<period;i++)
     {
      datetime time=iTime(_Symbol,PERIOD_CURRENT,bar+i);
      double open=iOpen(_Symbol,PERIOD_CURRENT,bar+i);
      string name="arrow"+IntegerToString(time);
      ObjectCreate(0,name,OBJ_ARROW,0,time,open);
      ObjectSetInteger(0,name,OBJPROP_ARROWCODE,159);
      ObjectSetInteger(0,name,OBJPROP_COLOR,clrBlue);
      ObjectSetInteger(0,name,OBJPROP_WIDTH,5);
     }

   ChartRedraw();
   Sleep(5000);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalcData(double &a[])
  {
//---
   for(int i=0;i<diff;i++)
     {
      a[i]=0;
      int size=i+2;
      for(int j=0;j<size;j++)
         a[i]=a[i]+arr[i].c[j]*price[j];
      MathRound(a[i]);
      if(a[i]==0)
         a[i]=_Point;
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ShiftPrice(double open)
  {
//---
   for(int i=period-1;i>0;i--)
      price[i]=price[i-1];
   price[0]=(int)MathRound(open/_Point);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void FiniteDifference(double &a[],int &size)
  {
//---
   double b[];
   ArrayResize(b,size+1);
   ArrayInitialize(b,0);

   for(int i=0;i<size;i++)
      b[i]=a[i];

   for(int i=1;i<=size;i++)
      b[i]=MathRound(b[i]-a[i-1]);

   ArrayResize(a,size+1);
   ArrayCopy(a,b);
   size++;

   ArrayFree(b);
//---
  }
//+------------------------------------------------------------------+
